/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.OutputStream;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFileWriter;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyUnicode;
import org.python.core.util.StringUtil;

public class StdoutWrapper
extends OutputStream {
    protected String name = "stdout";

    protected PyObject getObject(PySystemState pySystemState) {
        return pySystemState.stdout;
    }

    protected void setObject(PySystemState pySystemState, PyObject pyObject) {
        pySystemState.stdout = pyObject;
    }

    protected PyObject myFile() {
        PySystemState pySystemState = Py.getSystemState();
        PyObject pyObject = this.getObject(pySystemState);
        if (pyObject == null) {
            throw Py.AttributeError("missing sys." + this.name);
        }
        if (pyObject.getJavaProxy() != null) {
            PyFile pyFile = null;
            Object object = pyObject.__tojava__(OutputStream.class);
            if (object != null && object != Py.NoConversion) {
                pyFile = new PyFile((OutputStream)object);
            }
            if (pyFile != null) {
                this.setObject(pySystemState, pyFile);
                return pyFile;
            }
        }
        return pyObject;
    }

    public void flush() {
        PyObject pyObject = this.myFile();
        if (pyObject instanceof PyFile) {
            ((PyFile)pyObject).flush();
        } else {
            try {
                pyObject.invoke("flush");
            }
            catch (PyException pyException) {
                // empty catch block
            }
        }
    }

    public void write(String string) {
        PyObject pyObject = this.myFile();
        if (pyObject instanceof PyFile) {
            ((PyFile)pyObject).write(string);
        } else {
            pyObject.invoke("write", new PyString(string));
        }
    }

    public void write(int n) {
        this.write(new String(new char[]{(char)n}));
    }

    public void write(byte[] byArray, int n, int n2) {
        this.write(StringUtil.fromBytes(byArray, n, n2));
    }

    public void flushLine() {
        PyObject pyObject = this.myFile();
        if (pyObject instanceof PyFile) {
            PyFile pyFile = (PyFile)pyObject;
            if (pyFile.softspace) {
                pyFile.write("\n");
                pyFile.flush();
            }
            pyFile.softspace = false;
        } else {
            PyObject pyObject2 = pyObject.__findattr__("softspace");
            if (pyObject2 != null && pyObject2.__nonzero__()) {
                pyObject.invoke("write", Py.Newline);
            }
            try {
                pyObject.invoke("flush");
            }
            catch (PyException pyException) {
                // empty catch block
            }
            pyObject.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }

    public void print(PyObject pyObject, boolean bl, boolean bl2) {
        PyObject pyObject2 = this.myFile();
        if (pyObject2 instanceof PyFile) {
            PyFile pyFile = (PyFile)pyObject2;
            if (pyFile.softspace) {
                pyFile.write(" ");
                pyFile.softspace = false;
            }
            String string = pyObject instanceof PyUnicode && pyFile.encoding != null ? ((PyUnicode)pyObject).encode(pyFile.encoding, "strict") : pyObject.__str__().toString();
            pyFile.write(string);
            if (pyObject instanceof PyString) {
                int n = string.length();
                if (n == 0 || !Character.isWhitespace(string.charAt(n - 1)) || string.charAt(n - 1) == ' ') {
                    pyFile.softspace = bl;
                }
            } else {
                pyFile.softspace = bl;
            }
            if (bl2) {
                pyFile.write("\n");
                pyFile.softspace = false;
            }
            pyFile.flush();
        } else if (pyObject2 instanceof PyFileWriter) {
            PyFileWriter pyFileWriter = (PyFileWriter)pyObject2;
            if (pyFileWriter.softspace) {
                pyFileWriter.write(" ");
                pyFileWriter.softspace = false;
            }
            String string = pyObject instanceof PyString ? ((PyString)pyObject).getString() : pyObject.toString();
            pyFileWriter.write(string);
            if (pyObject instanceof PyString) {
                int n = string.length();
                if (n == 0 || !Character.isWhitespace(string.charAt(n - 1)) || string.charAt(n - 1) == ' ') {
                    pyFileWriter.softspace = bl;
                }
            } else {
                pyFileWriter.softspace = bl;
            }
            if (bl2) {
                pyFileWriter.write("\n");
                pyFileWriter.softspace = false;
            }
            pyFileWriter.flush();
        } else {
            PyObject pyObject3 = pyObject2.__findattr__("softspace");
            if (pyObject3 != null && pyObject3.__nonzero__()) {
                pyObject2.invoke("write", Py.Space);
                pyObject2.__setattr__("softspace", (PyObject)Py.Zero);
            }
            if (!(pyObject instanceof PyUnicode)) {
                pyObject = pyObject.__str__();
            }
            pyObject2.invoke("write", pyObject);
            if (pyObject instanceof PyString) {
                String string = pyObject.toString();
                int n = string.length();
                if (n == 0 || !Character.isWhitespace(string.charAt(n - 1)) || string.charAt(n - 1) == ' ') {
                    pyObject2.__setattr__("softspace", (PyObject)(bl ? Py.One : Py.Zero));
                }
            } else {
                pyObject2.__setattr__("softspace", (PyObject)(bl ? Py.One : Py.Zero));
            }
            if (bl2) {
                pyObject2.invoke("write", Py.Newline);
                pyObject2.__setattr__("softspace", (PyObject)Py.Zero);
            }
        }
    }

    public void print(String string) {
        this.print(new PyString(string), false, false);
    }

    public void println(String string) {
        this.print(new PyString(string), false, true);
    }

    public void print(PyObject pyObject) {
        this.print(pyObject, false, false);
    }

    public void printComma(PyObject pyObject) {
        this.print(pyObject, true, false);
    }

    public void println(PyObject pyObject) {
        this.print(pyObject, false, true);
    }

    public void println() {
        PyObject pyObject = this.myFile();
        if (pyObject instanceof PyFile) {
            PyFile pyFile = (PyFile)pyObject;
            pyFile.write("\n");
            pyFile.flush();
            pyFile.softspace = false;
        } else {
            pyObject.invoke("write", Py.Newline);
            pyObject.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }
}

